/*
 * Decompiled with CFR 0.152.
 */
package e;

import e.HmacSha256;
import e.SHA256;
import e.SecurityConfig;
import e.Static;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public final class ResourceCrypto {
    private static final byte[] MAGIC;

    private static byte[] sha256(byte[] data) {
        return SHA256.digest(data);
    }

    private static byte[] hmac(byte[] key, byte[] data) {
        return HmacSha256.hmac(key, data);
    }

    private static byte[] concat(byte[] a2, byte[] b) {
        byte[] r = new byte[a2.length + b.length];
        System.arraycopy(a2, 0, r, 0, a2.length);
        System.arraycopy(b, 0, r, a2.length, b.length);
        return r;
    }

    private static byte[] keystream(String path, int length) {
        byte[] pk = ResourceCrypto.concat(SecurityConfig.key(), path.getBytes());
        int blocks = (length + 31) / 32;
        byte[] out = new byte[blocks * 32];
        for (int i = 0; i < blocks; ++i) {
            byte[] ib = new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i};
            byte[] dig = ResourceCrypto.sha256(ResourceCrypto.concat(pk, ib));
            System.arraycopy(dig, 0, out, i * 32, 32);
        }
        if (out.length != length) {
            byte[] trimmed = new byte[length];
            System.arraycopy(out, 0, trimmed, 0, length);
            return trimmed;
        }
        return out;
    }

    public static byte[] decryptIfNeeded(String path, byte[] in) {
        if (in == null || in.length < MAGIC.length + 32) {
            return in;
        }
        for (int i = 0; i < MAGIC.length; ++i) {
            if (in[i] == MAGIC[i]) continue;
            return in;
        }
        byte[] tag = new byte[32];
        System.arraycopy(in, MAGIC.length, tag, 0, 32);
        int off = MAGIC.length + 32;
        int len = in.length - off;
        byte[] ks = ResourceCrypto.keystream(path, len);
        byte[] plain = new byte[len];
        for (int i = 0; i < len; ++i) {
            plain[i] = (byte)(in[off + i] ^ ks[i]);
        }
        byte[] calc = ResourceCrypto.hmac(SecurityConfig.key(), ResourceCrypto.concat(path.getBytes(), plain));
        boolean ok = true;
        for (int i = 0; i < 32; ++i) {
            if (calc[i] == tag[i]) continue;
            ok = false;
            break;
        }
        if (!ok) {
            return in;
        }
        return plain;
    }

    public static byte[] readResource(String path) {
        InputStream is = null;
        try {
            int r;
            is = "".getClass().getResourceAsStream(path);
            if (is == null) {
                return null;
            }
            int avail = is.available();
            byte[] buf = new byte[avail];
            for (int read = 0; read < avail && (r = is.read(buf, read, avail - read)) >= 0; read += r) {
            }
            is.close();
            return ResourceCrypto.decryptIfNeeded(path, buf);
        }
        catch (Exception e) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static InputStream open(String path) {
        byte[] data = ResourceCrypto.readResource(path);
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data);
    }

    public static byte[] k3(byte[] in) {
        if (in.length == 0) {
            return in;
        }
        byte[] out = new byte[in.length];
        System.arraycopy(in, 0, out, 0, in.length);
        return out;
    }

    public static String i3(String s) {
        return s;
    }

    public static void cinitclone() {
        MAGIC = new byte[]{69, 78, 67, 49};
    }

    static {
        Static.regClass(48);
        ResourceCrypto.cinitclone();
    }

    public static void clears() {
        MAGIC = null;
    }
}

